<?php
    class Admin extends CI_Controller {

        public function __construct()
        {
            parent::__construct();

            // Checa se o usuario esta logado
            if (!$this->session->userdata('logged_in'))
            {
                redirect('auth');
            }

            $this->load->model('Auth_model');

            // Checa se o usuario é admin
            if (!$this->Auth_model->is_admin())
            {
                redirect('auth');
            }

            $this->load->library('form_validation');

            $this->load->model('Admin_model');
        }

        public function index()
        {
            $dropdown = array(
                'nota' => array(
                    '' => '--',
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                ),

                'status' => array(
                    '' => '--',
                    'Candidato' => 'Candidato',
                    'Eliminado' => 'Eliminado',
                    'Entrevistado' => 'Entrevistado',
                    'Funcionário' => 'Funcionário',
                    'Ex-funcionário' => 'Ex-funcionário'
                ),

                'area_desejada' => array(
                    '' => '--',
                    'Administrativo' => 'Administrativo',
                    'Comercial' => 'Comercial',
                    'Comércio Exterior' => 'Comércio Exterior',
                    'Compras' => 'Compras',
                    'Contabilidade' => 'Contabilidade',
                    'Estilo' => 'Estilo',
                    'Financeiro' => 'Financeiro',
                    'Gerente de Projetos' => 'Gerente de Projetos',
                    'Jurídico' => 'Jurídico',
                    'Logística' => 'Logística',
                    'Marketing' => 'Marketing',
                    'Produção Visual' => 'Produção Visual',
                    'Recursos Humanos' => 'Recursos Humanos',
                    'Supervisão de Lojas' => 'Supervisão de Lojas',
                    'Vendas' => 'Vendas'
                ),

                'hierarquia' => array(
                    '' => '--',
                    'Estagiário' => 'Estagiário',
                    'Profissional Junior' => 'Profissional Junior',
                    'Profissional Pleno' => 'Profissional Pleno',
                    'Profissional Senior' => 'Profissional Senior'
                )
            );

            // Paginação
            $this->load->library('pagination');

            $search = array(
                'nome' => $this->input->get_post('nome'),
                'nota' => $this->input->get_post('nota'),
                'status' => $this->input->get_post('status'),
                'area_desejada' => $this->input->get_post('area_desejada'),
                'hierarquia' => $this->input->get_post('hierarquia')
            );

            $config['base_url'] = current_url() . '?' . http_build_query($search);
            $config['total_rows'] = $this->Admin_model->count_result();
            $config['per_page'] = 20;
            $config['num_links'] = 4;
            $config['page_query_string'] = TRUE;
            $config['next_link'] = FALSE;
            $config['prev_link'] = FALSE;
            $config['last_link'] = '>>';
            $config['first_link'] = '<<';
            $config['full_tag_open'] = '<div class="pagination">';
            $config['full_tag_close'] = '</div>';
            $config['cur_tag_open'] = '<a href="#" id="ativo">';
            $config['cur_tag_close'] = '</a>';

            $this->pagination->initialize($config);

            $info = array(
                'title' => 'RH Redley - Admin',
                'message' => $this->session->flashdata('message'),
                'dropdown' => $dropdown,
                'pagination' => $this->pagination->create_links(),
                'curriculos' => $this->Admin_model->list_curriculo($config['per_page'], $this->input->get('per_page'))
            );

            $this->load->view('template/header', $info);
            $this->load->view('admin/list');
            $this->load->view('template/footer');
        }

        public function edit($id)
        {
            $dropdown = array(
                'sexo' => array(
                    'm' => 'Masculino',
                    'f' => 'Feminino'
                ),

                'nota' => array(
                    '' => '--',
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                ),

                'status' => array(
                    '' => '--',
                    'Candidato' => 'Candidato',
                    'Eliminado' => 'Eliminado',
                    'Entrevistado' => 'Entrevistado',
                    'Funcionário' => 'Funcionário',
                    'Ex-funcionário' => 'Ex-funcionário'
                ),

                'est_civil' => array(
                    'Solteiro' => 'Solteiro',
                    'Casado' => 'Casado',
                    'Viuvo' => 'Viuvo',
                    'Separado' => 'Separado',
                    'Divorciado' => 'Divorciado'
                ),

                'escolaridade' => array(
                    'Fundamental' => 'Fundamental',
                    '2º Grau Incompleto' => '2º Grau Incompleto',
                    '2º Grau' => '2º Grau',
                    'Técnico' => 'Técnico',
                    'Superior Incompleto' => 'Superior Incompleto',
                    'Superior' => 'Superior',
                    'Pós-graduação' => 'Pós-graduação',
                    'Mestrado' => 'Mestrado',
                    'Doutorado' => 'Doutorado'
                ),

                'idioma' => array(
                    '' => '',
                    'Básico' => 'Básico',
                    'Intermediário' => 'Intermediário',
                    'Fluente' => 'Fluente'
                ),

                'area_desejada' => array(
                    'Atendimento' => 'Atendimento',
                    'Desenvolvedor Flash' => 'Desenvolvedor Flash',
                    'Desenvolvedor PHP' => 'Desenvolvedor PHP',
                    'Diretor de Arte' => 'Diretor de Arte',
                    'Gerente de Projetos' => 'Gerente de Projetos',
                    'Jornalista' => 'Jornalista',
                    'Programador HTML' => 'Programador HTML',
                    'Webdesigner' => 'Webdesigner'
                ),

                'hierarquia' => array(
                    'Estagiário' => 'Estagiário',
                    'Profissional Junior' => 'Profissional Junior',
                    'Profissional Pleno' => 'Profissional Pleno',
                    'Profissional Senior' => 'Profissional Senior'
                )
            );

            $info = array(
                'title' => 'RH Redley - Admin Editar',
                'message' => $this->session->flashdata('message'),
                'dropdown' => $dropdown,
                'data' => $this->Admin_model->fetch_curriculo($id)
            );

            $this->load->view('template/header', $info);
            $this->load->view('admin/edit');
            $this->load->view('template/footer');
        }

        public function do_update($id)
        {
            // Validacao dos campos
            $config = array(
                array(
                    'field'   => 'nome',
                    'label'   => 'Nome',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'email',
                    'label'   => 'Email',
                    'rules'   => 'required|trim|valid_email|xss_clean'
                ),

                array(
                    'field'   => 'cpf',
                    'label'   => 'CPF',
                    'rules'   => 'required|trim|xss_clean'
                ),

                array(
                    'field'   => 'data_nasc',
                    'label'   => 'Data nascimento',
                    'rules'   => 'required|trim|exact_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'sexo',
                    'label'   => 'Sexo',
                    'rules'   => 'required|trim|exact_length[1]|xss_clean'
                ),

                array(
                    'field'   => 'est_civil',
                    'label'   => 'Estado civil',
                    'rules'   => 'required|trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'telefone',
                    'label'   => 'Telefone',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'endereco',
                    'label'   => 'Endereço',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'bairro',
                    'label'   => 'Bairro',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'cidade',
                    'label'   => 'Cidade',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'estado',
                    'label'   => 'Estado',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'cep',
                    'label'   => 'CEP',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'pais',
                    'label'   => 'País',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'escolaridade[]',
                    'label'   => 'Escolaridade',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'curso[]',
                    'label'   => 'Curso',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'instituicao[]',
                    'label'   => 'Instituição',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'data_inicio_formacao[]',
                    'label'   => 'Data inicio formação',
                    'rules'   => 'required|trim|exact_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'data_inicio_emp[]',
                    'label'   => 'Data inicio empresa',
                    'rules'   => 'trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'data_fim_emp[]',
                    'label'   => 'Data fim empresa',
                    'rules'   => 'trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'area_desejada',
                    'label'   => 'Área desejada',
                    'rules'   => 'required|trim|max_length[19]|xss_clean'
                ),

                array(
                    'field'   => 'hierarquia',
                    'label'   => 'Hierarquia',
                    'rules'   => 'required|max_length[19]|xss_clean'
                ),

                array(
                    'field'   => 'obj_pessoal',
                    'label'   => 'Objetivo pessoal',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'pret_salarial',
                    'label'   => 'Pretensão salarial',
                    'rules'   => 'required|xss_clean'
                ),
            );

            $this->form_validation->set_rules($config);

            if ($this->form_validation->run() == TRUE)
            {
                if (!$this->Admin_model->edit($id))
                {
                    $this->session->set_flashdata('message', 'Ocorreu um erro ao editar seu curriculo. Por favor tente novamente.');
                    redirect('admin/edit/' . $id);
                }

                $this->session->set_flashdata('mensagem', 'Curriculo atualizado corretamente.');
                redirect('admin');
            }
            else
            {
                // Se houver algum erro de validacao ele retorna para a pagina inicial e exibe os erros
                $this->session->set_flashdata('message', validation_errors());
                redirect('admin/edit/' . $id);
            }
        }

        public function del($id)
        {
            if ($this->Admin_model->del($id))
            {
                $this->session->set_flashdata('message', 'Curriculo removido com sucesso.');
                redirect('admin');
            }
            else
            {
                $this->session->set_flashdata('message', 'Ocorreu um erro ao remover o curriculo selecionado. Por favor tente novamente.');
                redirect('admin');
            }
        }

        /*// Importa os curriculos do rh antigo(cake) para o novo(codeigniter).
        public function import_curriculo()
        {
            // Conecta no antigo banco de dados
            $config['hostname'] = "localhost";
            $config['username'] = "root";
            $config['password'] = "pura";
            $config['database'] = "rh_old";
            $config['dbdriver'] = "mysql";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";

            $old_db = $this->load->database($config, TRUE);

            $old_db->select('id, nivel, email, senha, criado');

            $result_user = $old_db->get('usuarios')->result();

            // Conecta no novo banco de dados
            $config2['hostname'] = "localhost";
            $config2['username'] = "root";
            $config2['password'] = "pura";
            $config2['database'] = "pura_rh";
            $config2['dbdriver'] = "mysql";
            $config2['dbprefix'] = "";
            $config2['pconnect'] = FALSE;
            $config2['db_debug'] = TRUE;
            $config2['cache_on'] = FALSE;
            $config2['cachedir'] = "";
            $config2['char_set'] = "utf8";
            $config2['dbcollat'] = "utf8_general_ci";

            $new_db = $this->load->database($config2, TRUE);

            foreach ($result_user as $key => $user)
            {
                if ($user->id != 1)
                {
                    $old_db->select('atualizado, foto, thumb, nome, sexo, estado_civil, cpf, data_nasc, nome_mae, nome_pai, objetivo, telefone, celular, site, endereco, complemento, bairro, cep, cidade, uf, pais, f1_grau, f1_curso, f1_dt_ini, f1_dt_fim, f1_ano_atual, f1_instituicao, f1_complemento, f2_grau, f2_curso, f2_dt_ini, f2_dt_fim, f2_ano_atual, f2_instituicao, f2_complemento, f3_grau, f3_curso, f3_dt_ini, f3_dt_fim, f3_ano_atual, f3_instituicao, f3_complemento, ingles, p1_dt_ini, p1_dt_fim, p1_empresa, p1_cargo, p1_atividades, p1_mot_saida, p2_dt_ini, p2_dt_fim, p2_empresa, p2_cargo, p2_atividades, p2_mot_saida, p3_dt_ini, p3_dt_fim, p3_empresa, p3_cargo, p3_atividades, p3_mot_saida, area_desejada1, nivel_hierarquico1, data_entrevista, obs_rh, obs_comportamental, obs_design, obs_tecnico, rating, status, psalarial, pqacredita');

                    $old_db->where('usuario_id', $user->id);

                    $curriculo = $old_db->get('curriculos')->row();

                    $data['email'] = $user->email;
                    $data['password'] = $user->senha;
                    $data['group'] = 'user';
                    $data['nome'] = $curriculo->nome;
                    $data['cpf'] = $curriculo->cpf;
                    $data['data_nasc'] = $curriculo->data_nasc;
                    $data['sexo'] = strtolower($curriculo->sexo);
                    $data['est_civil'] = $curriculo->estado_civil;

                    if (!empty($curriculo->site))
                    {
                        $data['portf_digital'] = $curriculo->site;
                    }

                    $data['foto'] = 'public/foto/' . $curriculo->foto;
                    $data['foto_thumb'] = 'public/foto/' . $curriculo->thumb;
                    $data['telefone'] = $curriculo->telefone;
                    $data['celular'] = $curriculo->celular;
                    $data['endereco'] = $curriculo->endereco;
                    $data['bairro'] = $curriculo->bairro;
                    $data['cidade'] = $curriculo->cidade;
                    $data['estado'] = $curriculo->uf;
                    $data['complemento'] = $curriculo->complemento;
                    $data['cep'] = $curriculo->cep;
                    $data['pais'] = $curriculo->pais;

                    // Area desejada
                    if ($curriculo->area_desejada1 == 'Diretor de arte')
                    {
                        $data['area_desejada'] = 'Diretor de Arte';
                    }
                    elseif ($curriculo->area_desejada1 == 'Gerente de projetos')
                    {
                        $data['area_desejada'] = 'Gerente de Projetos';
                    }
                    elseif ($curriculo->area_desejada1 == 'Websdesigner')
                    {
                        $data['area_desejada'] = 'Webdesigner';
                    }
                    else
                    {
                        $data['area_desejada'] = $curriculo->area_desejada1;
                    }

                    $data['hierarquia'] = $curriculo->nivel_hierarquico1;
                    $data['obj_pessoal'] = $curriculo->pqacredita;
                    $data['pret_salarial'] = $curriculo->psalarial;
                    $data['data_entrevista'] = $curriculo->data_entrevista;
                    $data['obs_rh'] = $curriculo->obs_rh;
                    $data['obs_comportamental'] = $curriculo->obs_comportamental;
                    $data['obs_design'] = $curriculo->obs_design;
                    $data['obs_tecnico'] = $curriculo->obs_tecnico;
                    $data['nota'] = $curriculo->rating;
                    $data['status'] = $curriculo->status;
                    $data['created'] = $user->criado;
                    $data['modified'] = $curriculo->atualizado;

                    $new_db->insert('rh_curriculo', $data);

                    $curriculo_id = $new_db->insert_id();

                    // Formacao
                    // 1
                    $formacao1['curriculo_id'] = $curriculo_id;

                    if ($curriculo->f1_grau == 'Pos-Graduação')
                    {
                        $formacao1['escolaridade'] = 'Pós-graduação';
                    }
                    elseif ($curriculo->f1_grau == 'Mestrado/Doutorado')
                    {
                        $formacao1['escolaridade'] = 'Mestrado';
                    }
                    else
                    {
                        $formacao1['escolaridade'] = $curriculo->f1_grau;
                    }

                    $formacao1['curso'] = $curriculo->f1_curso;
                    $formacao1['instituicao'] =  $curriculo->f1_instituicao;
                    
                    if (empty($curriculo->f1_dt_ini))
                    {
                        $formacao1['data_inicio'] = '0000-00-00';
                    }
                    else
                    {
                        $formacao1['data_inicio'] = $curriculo->f1_dt_ini;
                    }

                    if (!empty($curriculo->f1_dt_fim))
                    {
                        $formacao1['data_fim'] = $curriculo->f1_dt_fim;
                    }

                    if (!empty($curriculo->f1_complemento))
                    {
                        $formacao1['observacoes'] = $curriculo->f1_complemento;
                    }

                    $formacao1['created'] = $user->criado;

                    $new_db->insert('rh_formacao', $formacao1);

                    // 2
                    if (!empty($curriculo->f2_curso))
                    {
                        $formacao2['curriculo_id'] = $curriculo_id;

                        if ($curriculo->f2_grau == 'Pos-Graduação')
                        {
                            $formacao2['escolaridade'] = 'Pós-graduação';
                        }
                        elseif ($curriculo->f2_grau == 'Mestrado/Doutorado')
                        {
                            $formacao2['escolaridade'] = 'Mestrado';
                        }
                        else
                        {
                            $formacao2['escolaridade'] = $curriculo->f2_grau;
                        }

                        $formacao2['curso'] = $curriculo->f2_curso;
                        $formacao2['instituicao'] = $curriculo->f2_instituicao;

                        if (empty($curriculo->f2_dt_ini))
                        {
                            $formacao2['data_inicio'] = '0000-00-00';
                        }
                        else
                        {
                            $formacao2['data_inicio'] = $curriculo->f2_dt_ini;
                        }

                        if (!empty($curriculo->f2_dt_fim))
                        {
                            $formacao2['data_fim'] = $curriculo->f2_dt_fim;
                        }

                        if (!empty($curriculo->f2_complemento))
                        {
                            $formacao2['observacoes'] = $curriculo->f2_complemento;
                        }

                        $formacao2['created'] = $user->criado;

                        $new_db->insert('rh_formacao', $formacao2);
                    }

                    // 3
                    if (!empty($curriculo->f3_curso))
                    {
                        $formacao3['curriculo_id'] = $curriculo_id;

                        if ($curriculo->f3_grau == 'Pos-Graduação')
                        {
                            $formacao3['escolaridade'] = 'Pós-graduação';
                        }
                        elseif ($curriculo->f3_grau == 'Mestrado/Doutorado')
                        {
                            $formacao3['escolaridade'] = 'Mestrado';
                        }
                        else
                        {
                            $formacao3['escolaridade'] = $curriculo->f3_grau;
                        }

                        $formacao3['curso'] = $curriculo->f3_curso;
                        $formacao3['instituicao'] = $curriculo->f3_instituicao;

                        if (empty($curriculo->f3_dt_ini))
                        {
                            $formacao3['data_inicio'] = '0000-00-00';
                        }
                        else
                        {
                            $formacao3['data_inicio'] = $curriculo->f3_dt_ini;
                        }

                        if (!empty($curriculo->f3_dt_fim))
                        {
                            $formacao3['data_fim'] = $curriculo->f3_dt_fim;
                        }

                        if (!empty($curriculo->f3_complemento))
                        {
                            $formacao3['observacoes'] = $curriculo->f3_complemento;
                        }

                        $formacao3['created'] = $user->criado;

                        $new_db->insert('rh_formacao', $formacao3);
                    }

                    // Idioma
                    if ($curriculo->ingles > 0)
                    {
                        $idioma['curriculo_id'] = $curriculo_id;
                        $idioma['nome'] = 'Inglês';

                        if ($curriculo->ingles == 1)
                        {
                            $idioma['nivel'] = 'Básico';
                        }
                        elseif ($curriculo->ingles == 2)
                        {
                            $idioma['nivel'] = 'Intermediário';
                        }
                        else
                        {
                            $idioma['nivel'] = 'Fluente';
                        }

                        $idioma['created'] = $user->criado;

                        $new_db->insert('rh_idioma', $idioma);
                    }

                    // Profissional
                    // 1
                    if (!empty($curriculo->p1_cargo))
                    {
                        $profissional1['curriculo_id'] = $curriculo_id;
                        $profissional1['cargo'] = $curriculo->p1_cargo;
                        $profissional1['empresa'] = $curriculo->p1_empresa;

                        if (empty($curriculo->p1_dt_ini))
                        {
                            $profissional1['data_inicio'] = '0000-00-00';
                        }
                        else
                        {
                            $profissional1['data_inicio'] = $curriculo->p1_dt_ini;
                        }
                        
                        if (!empty($curriculo->p1_dt_fim))
                        {
                            $profissional1['data_fim'] = $curriculo->p1_dt_fim;
                        }

                        if (!empty($curriculo->p1_atividades))
                        {
                            $profissional1['atribuicoes'] = $curriculo->p1_atividades;
                        }
                        
                        if (!empty($curriculo->p1_mot_saida))
                        {
                            $profissional1['motivo_saida'] = $curriculo->p1_mot_saida;
                        }

                        $profissional1['created'] = $user->criado;

                        $new_db->insert('rh_profissional', $profissional1);
                    }

                    // 2
                    if (!empty($curriculo->p2_cargo))
                    {
                        $profissional2['curriculo_id'] = $curriculo_id;
                        $profissional2['cargo'] = $curriculo->p2_cargo;
                        $profissional2['empresa'] = $curriculo->p2_empresa;
                        
                        if (empty($curriculo->p2_dt_ini))
                        {
                            $profissional2['data_inicio'] = '0000-00-00';
                        }
                        else
                        {
                            $profissional2['data_inicio'] = $curriculo->p2_dt_ini;
                        }

                        if (!empty($curriculo->p2_dt_fim))
                        {
                            $profissional2['data_fim'] = $curriculo->p2_dt_fim;
                        }

                        if (!empty($curriculo->p2_atividades))
                        {
                            $profissional2['atribuicoes'] = $curriculo->p2_atividades;
                        }
                        
                        if (!empty($curriculo->p2_mot_saida))
                        {
                            $profissional2['motivo_saida'] = $curriculo->p2_mot_saida;
                        }

                        $profissional2['created'] = $user->criado;

                        $new_db->insert('rh_profissional', $profissional2);
                    }

                    // 3
                    if (!empty($curriculo->p3_cargo))
                    {
                        $profissional3['curriculo_id'] = $curriculo_id;
                        $profissional3['cargo'] = $curriculo->p3_cargo;
                        $profissional3['empresa'] = $curriculo->p3_empresa;
                        
                        if (empty($curriculo->p3_dt_ini))
                        {
                            $profissional3['data_inicio'] = '0000-00-00';
                        }
                        else
                        {
                            $profissional3['data_inicio'] = $curriculo->p3_dt_ini;
                        }

                        if (!empty($curriculo->p3_dt_fim))
                        {
                            $profissional3['data_fim'] = $curriculo->p3_dt_fim;
                        }

                        if (!empty($curriculo->p3_atividades))
                        {
                            $profissional3['atribuicoes'] = $curriculo->p3_atividades;
                        }
                        
                        if (!empty($curriculo->p3_mot_saida))
                        {
                            $profissional3['motivo_saida'] = $curriculo->p3_mot_saida;
                        }

                        $profissional3['created'] = $user->criado;

                        $new_db->insert('rh_profissional', $profissional3);
                    }
                }
            }
        }*/

        public function importar_novo_rh()
        {
            // Conecta no antigo banco de dados
            $config['hostname'] = "localhost";
            $config['username'] = "root";
            $config['password'] = "pura";
            $config['database'] = "rh_old";
            $config['dbdriver'] = "mysql";
            $config['dbprefix'] = "";
            $config['pconnect'] = FALSE;
            $config['db_debug'] = TRUE;
            $config['cache_on'] = FALSE;
            $config['cachedir'] = "";
            $config['char_set'] = "utf8";
            $config['dbcollat'] = "utf8_general_ci";

            $old_db = $this->load->database($config, TRUE);

            $old_db->select('id, email, senha, grupo, facebook_id, data_criacao, data_modificado');

            $result_user = $old_db->get('usuario')->result();

            // Conecta no novo banco de dados
            $config2['hostname'] = "localhost";
            $config2['username'] = "root";
            $config2['password'] = "pura";
            $config2['database'] = "pura_rh";
            $config2['dbdriver'] = "mysql";
            $config2['dbprefix'] = "";
            $config2['pconnect'] = FALSE;
            $config2['db_debug'] = TRUE;
            $config2['cache_on'] = FALSE;
            $config2['cachedir'] = "";
            $config2['char_set'] = "utf8";
            $config2['dbcollat'] = "utf8_general_ci";

            $new_db = $this->load->database($config2, TRUE);

            foreach ($result_user as $key => $user)
            {
                if ($user->id >= 666)
                {
                    $old_db->select('id, nome, foto, foto_thumb, sexo, estado_civil, cpf, data_nasc, telefone, celular, site, endereco, complemento, bairro, cep, cidade, estado, pais, area_desejada, nivel_hierarquico, data_entrevista, obs_rh, obs_comportamental, obs_design, obs_tecnico, nota, status, p_salarial, objetivo_pessoal, data_atualizado');

                    $curriculo = $old_db->get_where('curriculo', array('usuario_id' => $user->id))->row();

                    $data = array();

                    $data['email'] = $user->email;
                    $data['password'] = $user->senha;
                    $data['group'] = 'user';
                    $data['facebook_id'] = $user->facebook_id;
                    $data['nome'] = $curriculo->nome;
                    $data['cpf'] = $curriculo->cpf;
                    $data['data_nasc'] = $curriculo->data_nasc;
                    $data['sexo'] = $curriculo->sexo;
                    $data['est_civil'] = $curriculo->estado_civil;
                    $data['portf_digital'] = $curriculo->site;
                    $data['foto'] = $curriculo->foto;
                    $data['foto_thumb'] = $curriculo->foto_thumb;
                    $data['telefone'] = $curriculo->telefone;
                    $data['celular'] = $curriculo->celular;
                    $data['endereco'] = $curriculo->endereco;
                    $data['bairro'] = $curriculo->bairro;
                    $data['cidade'] = $curriculo->cidade;
                    $data['estado'] = $curriculo->estado;

                    if (!empty($curriculo->complemento))
                    {
                        $data['complemento'] = $curriculo->complemento;
                    }

                    $data['cep'] = $curriculo->cep;
                    $data['pais'] = $curriculo->pais;
                    $data['area_desejada'] = $curriculo->area_desejada;
                    $data['hierarquia'] = $curriculo->nivel_hierarquico;
                    $data['obj_pessoal'] = $curriculo->objetivo_pessoal;
                    $data['pret_salarial'] = $curriculo->p_salarial;
                    $data['data_entrevista'] = $curriculo->data_entrevista;

                    if (!empty($curriculo->obs_rh))
                    {
                        $data['obs_rh'] = $curriculo->obs_rh;
                    }

                    if (!empty($curriculo->obs_comportamental))
                    {
                        $data['obs_comportamental'] = $curriculo->obs_comportamental;
                    }

                    if (!empty($curriculo->obs_design))
                    {
                        $data['obs_design'] = $curriculo->obs_design;
                    }

                    if (!empty($curriculo->obs_tecnico))
                    {
                        $data['obs_tecnico'] = $curriculo->obs_tecnico;
                    }

                    if (!empty($curriculo->nota))
                    {
                        $data['nota'] = $curriculo->nota;
                    }

                    if (!empty($curriculo->status))
                    {
                        $data['status'] = $curriculo->status;
                    }

                    $data['created'] = $user->data_criacao;

                    if (!empty($user->data_modificado))
                    {
                        $data['modified'] = $user->data_modificado;
                    }
                    
                    $new_db->insert('rh_curriculo', $data);

                    $curriculo_id = $new_db->insert_id();

                    // Formacao
                    $old_db->select('escolaridade, curso, instituicao, data_inicio, data_fim, outra');

                    $formacoes = $old_db->get_where('formacao', array('curriculo_id' => $curriculo->id))->result();

                    foreach ($formacoes as $key => $formacao)
                    {
                        $data = array();

                        $data['escolaridade'] = $formacao->escolaridade;
                        $data['curso'] = $formacao->curso;
                        $data['instituicao'] = $formacao->instituicao;
                        $data['data_inicio'] = $formacao->data_inicio;

                        if (!empty($formacao->data_fim) OR ($formacao->data_fim != '0000-00-00'))
                        {
                            $data['data_fim'] = $formacao->data_fim;
                        }

                        if (!empty($formacao->outra))
                        {
                            $data['observacoes'] = $formacao->outra;
                        }

                        $data['curriculo_id'] = $curriculo_id;
                        $data['created'] = $user->data_criacao;
                        $data['modified'] = $user->data_modificado;

                        $new_db->insert('rh_formacao', $data);
                    }

                    // Idioma
                    $old_db->select('nome, nivel');

                    $idiomas = $old_db->get_where('idioma', array('curriculo_id' => $curriculo->id))->result();

                    foreach ($idiomas as $key => $idioma)
                    {
                        $data = array();

                        $data['nome'] = $idioma->nome;
                        $data['nivel'] = $idioma->nivel;
                        $data['curriculo_id'] = $curriculo_id;
                        $data['created'] = $user->data_criacao;
                        $data['modified'] = $user->data_modificado;

                        $new_db->insert('rh_idioma', $data);
                    }

                    // Profissional
                    $old_db->select('cargo, empresa, data_inicio, data_fim, atribuicoes, motivo_saida');

                    $profissionais = $old_db->get_where('exp_profissional', array('curriculo_id' => $curriculo->id))->result();

                    foreach ($profissionais as $key => $profissional)
                    {
                        $data = array();

                        $data['curriculo_id'] = $curriculo_id;
                        $data['cargo'] = $profissional->cargo;

                        if (!empty($profissional->empresa))
                        {
                            $data['empresa'] = $profissional->empresa;
                        }

                        $data['data_inicio'] = $profissional->data_inicio;

                        if (!empty($profissional->data_fim) OR ($profissional->data_fim == '0000-00-00'))
                        {
                            $data['data_fim'] = $profissional->data_fim;
                        }

                        if (!empty($profissional->atribuicoes))
                        {
                            $data['atribuicoes'] = $profissional->atribuicoes;
                        }

                        $data['motivo_saida'] = $profissional->motivo_saida;
                        $data['created'] = $user->data_criacao;
                        $data['modified'] = $user->data_modificado;

                        $new_db->insert('rh_profissional', $data);
                    }
                }
            }
        }

    }


/* End of file curriculo.php */
/* Location: ./application/controllers/curriculo.php */