<?php
    class Auth extends CI_Controller {

        public function __construct()
        {
            parent::__construct();

            $this->load->model('Auth_model');
        }

        public function index()
        {
            $info = array(
                'title' => 'RH Redley - Login',
                'message' => $this->session->flashdata('message'),
                'login' => TRUE
            );

            $this->load->view('template/header', $info);
            $this->load->view('login');
            $this->load->view('template/footer');
        }

        public function login()
        {
            $email = $this->input->post('usuario');
            $password = $this->input->post('senha');

            if (!$this->Auth_model->login($email, $password))
            {
                $this->session->set_flashdata('message', 'Usuario ou senha inválidos.');
                redirect('auth');
            }

            if ($this->Auth_model->is_admin())
            {
                redirect('admin');
            }

            redirect('curriculo/update');
        }

        public function facebook()
        {
            $fb_config = array(
                'appId'  => '121022158042987',
                'secret' => 'fdd53c5b4c80f91957d661459b720ba2'
            );

            $this->load->library('facebook', $fb_config);

            $user = $this->__facebook_token($fb_config);

            if (!empty($user))
            {
                $user_id = $this->facebook->getUser();

                if ($this->Auth_model->facebook_login($user_id))
                {
                    redirect('curriculo/update');
                }
                else
                {
                    $this->session->set_flashdata('message', 'Usuario não possui perfil.');
                    redirect('auth');
                }
            }
            else
            {
                $this->session->set_flashdata('message', 'Perfil não associado com nenhum curriculo.');
                redirect('auth');
            }
        }

        private function __facebook_token($fb_config)
        {
            if (isset($_COOKIE['fbsr_' . $fb_config['appId']]))
            {
                list($encoded_sig, $payload) = explode('.', $_COOKIE['fbsr_' . $fb_config['appId']], 2);

                $sig = base64_decode(strtr($encoded_sig, '-_', '+/'));
                $data = json_decode(base64_decode(strtr($payload, '-_', '+/')), true);

                if (strtoupper($data['algorithm']) !== 'HMAC-SHA256')
                {
                    return NULL;
                }

                $expected_sig = hash_hmac('sha256', $payload,
                $fb_config['secret'], $raw = true);
                if ($sig !== $expected_sig)
                {
                    return NULL;
                }

                $token_url = "https://graph.facebook.com/oauth/access_token?" . "client_id=" . $fb_config['appId'] . "&client_secret=" . $fb_config['secret']. "&redirect_uri=" . "&code=" . $data['code'];

                $response = @file_get_contents($token_url);
                $params = null;
                parse_str($response, $params);
                $data['access_token'] = $params['access_token'];

                return $data['access_token'];
            }

            return NULL;
        }

        public function forgot_password()
        {
            $info = array(
                'title' => 'Pura RH - Esqueci Minha Senha',
                'message' => $this->session->flashdata('message'),
                'login' => TRUE
            );

            $this->load->view('template/header', $info);
            $this->load->view('forgot_password');
            $this->load->view('template/footer');
        }

        public function reset_password()
        {
            $email = $this->input->post('email');

            $new_pass = $this->Auth_model->reset_password($email);

            if ($new_pass['result'])
            {
                $this->session->set_flashdata('message', 'Sua senha foi enviada para o email cadastrado.');

                $this->__send_mail($email, $new_pass['pass']);
            }
            else
            {
                $this->session->set_flashdata('message', 'Nenhum usuário com esse email.');
            }

            redirect('/');
        }

        private function __send_mail($email, $pass)
        {
            $this->load->library('email');

            $this->email->from('rh@redley.com.br', 'Pura RH');
            $this->email->to($email);

            $this->email->subject('Esqueci Minha Senha');
            $this->email->message("Nova senha: $pass");  

            $this->email->send();
        }

    }


/* End of file auth.php */
/* Location: ./application/controllers/auth.php */