<?php
    class Curriculo extends CI_Controller {

        public function __construct()
        {
            parent::__construct();

            $this->load->library('form_validation');

            $this->load->model('Curriculo_model');
        }

        public function index()
        {
            $info = array(
                'title' => 'RH Redley - Criar Curriculo',
                'message' => $this->session->flashdata('message')
            );

            $this->load->view('template/header', $info);
            $this->load->view('curriculo/add', $info);
            $this->load->view('template/footer', $info);
        }

        public function do_add()
        {
            // Validacao dos campos
            $config = array(
                array(
                    'field'   => 'nome',
                    'label'   => 'Nome',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'email',
                    'label'   => 'Email',
                    'rules'   => 'required|trim|valid_email|xss_clean'
                ),

                array(
                    'field'   => 'cpf',
                    'label'   => 'CPF',
                    'rules'   => 'required|trim|xss_clean'
                ),

                array(
                    'field'   => 'data_nasc',
                    'label'   => 'Data nascimento',
                    'rules'   => 'required|trim|exact_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'sexo',
                    'label'   => 'Sexo',
                    'rules'   => 'required|trim|exact_length[1]|xss_clean'
                ),

                array(
                    'field'   => 'est_civil',
                    'label'   => 'Estado civil',
                    'rules'   => 'required|trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'telefone',
                    'label'   => 'Telefone',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'endereco',
                    'label'   => 'Endereço',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'bairro',
                    'label'   => 'Bairro',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'cidade',
                    'label'   => 'Cidade',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'estado',
                    'label'   => 'Estado',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'cep',
                    'label'   => 'CEP',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'pais',
                    'label'   => 'País',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'senha',
                    'label'   => 'Senha',
                    'rules'   => 'required'
                ),

                array(
                    'field'   => 'conf_senha',
                    'label'   => 'Confirmação de senha',
                    'rules'   => 'required|matches[senha]'
                ),

                array(
                    'field'   => 'escolaridade[]',
                    'label'   => 'Escolaridade',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'curso[]',
                    'label'   => 'Curso',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'instituicao[]',
                    'label'   => 'Instituição',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'data_inicio_formacao[]',
                    'label'   => 'Data inicio formação',
                    'rules'   => 'required|trim|exact_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'data_inicio_emp[]',
                    'label'   => 'Data inicio empresa',
                    'rules'   => 'trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'data_fim_emp[]',
                    'label'   => 'Data fim empresa',
                    'rules'   => 'trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'area_desejada',
                    'label'   => 'Área desejada',
                    'rules'   => 'required|trim|max_length[19]|xss_clean'
                ),

                array(
                    'field'   => 'hierarquia',
                    'label'   => 'Hierarquia',
                    'rules'   => 'required|max_length[19]|xss_clean'
                ),

                array(
                    'field'   => 'obj_pessoal',
                    'label'   => 'Objetivo pessoal',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'pret_salarial',
                    'label'   => 'Pretensão salarial',
                    'rules'   => 'required|xss_clean'
                ),
            );

            $this->form_validation->set_rules($config);

            // Adiciona o curriculo, se positivo ele redireciona para a pagina de atualizar o curriculo.
            if ($this->form_validation->run() == TRUE)
            {
                if (!$this->Curriculo_model->add_curriculo())
                {
                    $this->session->set_flashdata('message', 'Usuário já existe.');
                    redirect('curriculo/index');
                }

                // Faz o login
                $this->load->model('Auth_model');

                $email = $this->input->post('email');
                $password = $this->input->post('senha');

                if ($this->Auth_model->login($email, $password))
                {
                	// Envio de email após cadastro
                    $this->load->library('parser');
                    $this->load->library('email');
                    $data = array(
                        'nome_usuario'     => $this->input->post('nome'),
                        'email_usuario' => $this->input->post('email'),
                        'cargo_pretendido' => $this->input->post('area_desejada')
                    );
                    $htmlMessage =  $this->parser->parse('template/email/create', $data, true);
                    $this->email->from('rh@redley.com.br','RH Redley');  
                    $this->email->to('rh@redley.com.br');
                    $this->email->subject(
                        'Sistema RH - Novo Cadastro - ' . $this->input->post('area_desejada')
                    );
                    $this->email->message( $htmlMessage );
                    $this->email->send();

                    redirect('curriculo/update/#sucesso');
                }
                else
                {
                    redirect('auth');
                }
            }
            else
            {
                // Se houver algum erro de validacao ele retorna para a pagina inicial e exibe os erros
                $this->session->set_flashdata('message', validation_errors());
                redirect('curriculo');
            }
        }

        public function update()
        {
            // Checa se o usuario esta logado
            if (!$this->session->userdata('logged_in'))
            {
                redirect('auth');
            }

            $id = $this->session->userdata('id');

            $dropdown = array(
                'sexo' => array(
                    'm' => 'Masculino',
                    'f' => 'Feminino'
                ),

                'est_civil' => array(
                    'Solteiro' => 'Solteiro',
                    'Casado' => 'Casado',
                    'Viuvo' => 'Viuvo',
                    'Separado' => 'Separado',
                    'Divorciado' => 'Divorciado'
                ),

                'escolaridade' => array(
                    'Fundamental' => 'Fundamental',
                    '2º Grau Incompleto' => '2º Grau Incompleto',
                    '2º Grau' => '2º Grau',
                    'Técnico' => 'Técnico',
                    'Superior Incompleto' => 'Superior Incompleto',
                    'Superior' => 'Superior',
                    'Pós-graduação' => 'Pós-graduação',
                    'Mestrado' => 'Mestrado',
                    'Doutorado' => 'Doutorado'
                ),

                'idioma' => array(
                    '' => '',
                    'Básico' => 'Básico',
                    'Intermediário' => 'Intermediário',
                    'Fluente' => 'Fluente'
                ),
                'area_desejada' => array(
                    'Administrativo' => 'Administrativo',
                    'Comercial' => 'Comercial',
                    'Comércio Exterior' => 'Comércio Exterior',
                    'Compras' => 'Compras',
                    'Contabilidade' => 'Contabilidade',
                    'Estilo' => 'Estilo',
                    'Financeiro' => 'Financeiro',
                    'Gerente de Projetos' => 'Gerente de Projetos',
                    'Jurídico' => 'Jurídico',
                    'Logística' => 'Logística',
                    'Marketing' => 'Marketing',
                    'Produção Visual' => 'Produção Visual',
                    'Recursos Humanos' => 'Recursos Humanos',
                    'Supervisão de Lojas' => 'Supervisão de Lojas',
                    'Vendas' => 'Vendas'
                ),
                'area_desejada2' => array(
                    'Administrativo' => 'Administrativo',
                    'Comercial' => 'Comercial',
                    'Comércio Exterior' => 'Comércio Exterior',
                    'Compras' => 'Compras',
                    'Contabilidade' => 'Contabilidade',
                    'Estilo' => 'Estilo',
                    'Financeiro' => 'Financeiro',
                    'Gerente de Projetos' => 'Gerente de Projetos',
                    'Jurídico' => 'Jurídico',
                    'Logística' => 'Logística',
                    'Marketing' => 'Marketing',
                    'Produção Visual' => 'Produção Visual',
                    'Recursos Humanos' => 'Recursos Humanos',
                    'Supervisão de Lojas' => 'Supervisão de Lojas',
                    'Vendas' => 'Vendas'
                ),

                'area_desejada3' => array(
                    'Administrativo' => 'Administrativo',
                    'Comercial' => 'Comercial',
                    'Comércio Exterior' => 'Comércio Exterior',
                    'Compras' => 'Compras',
                    'Contabilidade' => 'Contabilidade',
                    'Estilo' => 'Estilo',
                    'Financeiro' => 'Financeiro',
                    'Gerente de Projetos' => 'Gerente de Projetos',
                    'Jurídico' => 'Jurídico',
                    'Logística' => 'Logística',
                    'Marketing' => 'Marketing',
                    'Produção Visual' => 'Produção Visual',
                    'Recursos Humanos' => 'Recursos Humanos',
                    'Supervisão de Lojas' => 'Supervisão de Lojas',
                    'Vendas' => 'Vendas'
                ),

                'hierarquia' => array(
                    'Estagiário' => 'Estagiário',
                    'Profissional Junior' => 'Profissional Junior',
                    'Profissional Pleno' => 'Profissional Pleno',
                    'Profissional Senior' => 'Profissional Senior'
                ),

                'hierarquia2' => array(
                    'Estagiário' => 'Estagiário',
                    'Profissional Junior' => 'Profissional Junior',
                    'Profissional Pleno' => 'Profissional Pleno',
                    'Profissional Senior' => 'Profissional Senior'
                )
            );

            $info = array(
                'title' => 'RH Redley - Atualizar',
                'message' => $this->session->flashdata('message'),
                'dropdown' => $dropdown,
                'data' => $this->Curriculo_model->fetch_curriculo($id)
            );

            $this->load->view('template/header', $info);
            $this->load->view('curriculo/update');
            $this->load->view('template/footer');
        }

        public function do_update()
        {
            // Validacao dos campos
            $config = array(
                array(
                    'field'   => 'nome',
                    'label'   => 'Nome',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'email',
                    'label'   => 'Email',
                    'rules'   => 'required|trim|valid_email|xss_clean'
                ),

                array(
                    'field'   => 'cpf',
                    'label'   => 'CPF',
                    'rules'   => 'required|trim|xss_clean'
                ),

                array(
                    'field'   => 'data_nasc',
                    'label'   => 'Data nascimento',
                    'rules'   => 'required|trim|exact_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'sexo',
                    'label'   => 'Sexo',
                    'rules'   => 'required|trim|exact_length[1]|xss_clean'
                ),

                array(
                    'field'   => 'est_civil',
                    'label'   => 'Estado civil',
                    'rules'   => 'required|trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'telefone',
                    'label'   => 'Telefone',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'endereco',
                    'label'   => 'Endereço',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'bairro',
                    'label'   => 'Bairro',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'cidade',
                    'label'   => 'Cidade',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'estado',
                    'label'   => 'Estado',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'cep',
                    'label'   => 'CEP',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'pais',
                    'label'   => 'País',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'escolaridade[]',
                    'label'   => 'Escolaridade',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'curso[]',
                    'label'   => 'Curso',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'instituicao[]',
                    'label'   => 'Instituição',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'data_inicio_formacao[]',
                    'label'   => 'Data inicio formação',
                    'rules'   => 'required|trim|exact_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'data_inicio_emp[]',
                    'label'   => 'Data inicio empresa',
                    'rules'   => 'trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'data_fim_emp[]',
                    'label'   => 'Data fim empresa',
                    'rules'   => 'trim|max_length[10]|xss_clean'
                ),

                array(
                    'field'   => 'area_desejada',
                    'label'   => 'Área desejada',
                    'rules'   => 'required|trim|max_length[19]|xss_clean'
                ),

                array(
                    'field'   => 'hierarquia',
                    'label'   => 'Hierarquia',
                    'rules'   => 'required|max_length[19]|xss_clean'
                ),

                array(
                    'field'   => 'obj_pessoal',
                    'label'   => 'Objetivo pessoal',
                    'rules'   => 'required|xss_clean'
                ),

                array(
                    'field'   => 'pret_salarial',
                    'label'   => 'Pretensão salarial',
                    'rules'   => 'required|xss_clean'
                ),
            );

            $this->form_validation->set_rules($config);

            if ($this->form_validation->run() == TRUE)
            {
                $curriculo_id = $this->session->userdata('id');

                if (!$this->Curriculo_model->update_curriculo($curriculo_id))
                {
                    $this->session->set_flashdata('message', 'Ocorreu um erro ao atualizar seu curriculo. Por favor tente novamente.');
                    redirect('curriculo/update/');
                }

                // Envio de email após edição
                $this->load->library('parser');
                $this->load->library('email');
                $data = array(
                    'nome_usuario'     => $this->input->post('nome'),
                    'email_usuario' => $this->input->post('email'),
                    'cargo_pretendido' => $this->input->post('area_desejada')
                );
                $htmlMessage =  $this->parser->parse('template/email/update', $data, true);
                $this->email->from('rh@redley.com.br','RH Redley');  
                $this->email->to('rh@redley.com.br');
                $this->email->subject(
                    'Sistema RH - Atualização de Cadastro - ' . $this->input->post('area_desejada')
                );  
                $this->email->message( $htmlMessage );
                $this->email->send(); 

                $this->session->set_flashdata('mensagem', 'Curriculo atualizado corretamente.');
                redirect('curriculo/update/');
            }
            else
            {
                // Se houver algum erro de validacao ele retorna para a pagina inicial e exibe os erros
                $this->session->set_flashdata('message', validation_errors());
                redirect('curriculo/update/');
            }
        }

    }


/* End of file curriculo.php */
/* Location: ./application/controllers/curriculo.php */