<?php
    class Admin_model extends CI_Model {

        public function __construct()
        {
            parent::__construct();
        }

        public function count_result()
        {
            $nomes = $this->input->get('nome');

            if ($nomes)
            {
                // Faz a busca por varios nomes como Iva Pestana
                $lista_nomes = explode(' ', $nomes);

                foreach ($lista_nomes as $key => $nome)
                {
                    $this->db->like('nome', $nome);
                }
            }

            $nota = $this->input->get('nota');

            if ($nota)
            {
                $this->db->where('nota', $nota);
            }

            $status = $this->input->get('status');

            if ($status)
            {
                $this->db->where('status', $status);
            }

            $area_desejada = $this->input->get('area_desejada');

            if ($area_desejada)
            {
                $this->db->where('area_desejada', $area_desejada);
            }

            $hierarquia = $this->input->get('hierarquia');

            if ($hierarquia)
            {
                $this->db->where('hierarquia', $hierarquia);
            }

            $this->db->from('rh_curriculo');

            return $this->db->count_all_results();
        }

        public function list_curriculo($limit, $offset)
        {
            $this->db->select('id, email, nome, foto_thumb, pret_salarial, area_desejada, hierarquia, nota, status, modified');

            // Filtros de busca

            // Somente usuario. Exclui o perfil admin
            $this->db->where('group', 'user');

            $nomes = $this->input->get('nome');

            if ($nomes)
            {
                // Faz a busca por varios nomes como Iva Pestana
                $list_nome = explode(' ', $nomes);

                foreach ($list_nome as $key => $nome)
                {
                    $this->db->like('nome', $nome);
                }
            }

            $nota = $this->input->get('nota');

            if ($nota)
            {
                $this->db->where('nota', $nota);
            }

            $status = $this->input->get('status');

            if ($status)
            {
                $this->db->where('status', $status);
            }

            $area_desejada = $this->input->get('area_desejada');

            if ($area_desejada)
            {
                $this->db->where('area_desejada', $area_desejada);
                $this->db->or_where('area_desejada2', $area_desejada);
                $this->db->or_where('area_desejada3', $area_desejada);
            }

            $hierarquia = $this->input->get('hierarquia');

            if ($hierarquia)
            {
                $this->db->where('hierarquia', $hierarquia);
            }

            $this->db->order_by('id', 'desc');

            $this->db->limit($limit, $offset);

            return $this->db->get('rh_curriculo')->result();
        }

        public function fetch_curriculo($id)
        {
            // Curriculo
            $this->db->select('id, email, nome, cpf, data_nasc, sexo, est_civil, portf_digital, foto, telefone, celular, endereco, bairro, cidade, estado, complemento, cep, pais, area_desejada, hierarquia, obj_pessoal, pret_salarial, data_entrevista, obs_rh, obs_comportamental, obs_design, obs_tecnico, nota, status');

            $data['curriculo'] = $this->db->get_where('rh_curriculo', array('id' => $id))->row();

            // Formacao
            $this->db->select('id, escolaridade, curso, instituicao, data_inicio, data_fim, observacoes');

            $data['formacoes'] = $this->db->get_where('rh_formacao', array('curriculo_id' => $id))->result();

            // Idioma
            $this->db->select('id, nome, nivel');

            $data['idiomas'] = $this->db->get_where('rh_idioma', array('curriculo_id' => $id))->result();

            // Profissional
            $this->db->select('id, cargo, empresa, data_inicio, data_fim, atribuicoes, motivo_saida');

            $data['profissionais'] = $this->db->get_where('rh_profissional', array('curriculo_id' => $id))->result();

            return $data;
        }

        public function edit($id)
        {
            // Organiza os dados
            $data = array(
                'email' => $this->input->post('email'),
                'facebook_id' => $this->input->post('facebook_id'),
                'nome' => $this->input->post('nome'),
                'cpf' => $this->input->post('cpf'),
                'data_nasc' => date('Y-m-d', strtotime($this->input->post('data_nasc'))),
                'sexo' => $this->input->post('sexo'),
                'est_civil' => $this->input->post('est_civil'),
                'portf_digital' => $this->input->post('portf_digital'),
                'telefone' => $this->input->post('telefone'),
                'celular' => $this->input->post('celular'),
                'endereco' => $this->input->post('endereco'),
                'bairro' => $this->input->post('bairro'),
                'cidade' => $this->input->post('cidade'),
                'estado' => $this->input->post('estado'),
                'complemento' => $this->input->post('compl'),
                'cep' => $this->input->post('cep'),
                'pais' => $this->input->post('pais'),
                'area_desejada' => $this->input->post('area_desejada'),
                'hierarquia' => $this->input->post('hierarquia'),
                'obj_pessoal' => $this->input->post('obj_pessoal'),
                'pret_salarial' => $this->input->post('pret_salarial'),
                'obs_rh' => $this->input->post('observacao'),
                'obs_comportamental' => $this->input->post('comportamental'),
                'obs_design' => $this->input->post('design'),
                'obs_tecnico' => $this->input->post('tecnico'),
                'modified' => date("Y-m-d H:i:s")
            );

            $data_entrevista = $this->input->post('entrevista');
            if (!empty($data_entrevista))
            {
                $data['data_entrevista'] = $data_entrevista;
            }

            $nota = $this->input->post('nota');
            if (!empty($nota))
            {
                $data['nota'] = $nota;
            }

            $status = $this->input->post('status');
            if (!empty($status))
            {
                $data['status'] = $status;
            }

            $password = $this->input->post('senha');

            // Verifica se a senha foi alterado, se tiver sido ele altera a senha
            if (!empty($password))
            {
                // PHPASS para encriptografar a senha
                require_once(dirname(__FILE__) . '/../libraries/phpass-0.3/PasswordHash.php');

                $this->phpass = new PasswordHash(8, false);

                $data['password'] = $this->phpass->HashPassword($password);
            }

            $this->db->where('id', $id);
            $this->db->update('rh_curriculo', $data);

            // Formacao
            $this->edit_formacao($id);

            // Idioma
            $this->edit_idioma($id);

            // Profissional
            $this->edit_profissional($id);

            return TRUE;
        }

        private function edit_formacao($curriculo_id)
        {
            $formacao_id = $this->input->post('formacao_id');
            $escolaridade = $this->input->post('escolaridade');
            $curso = $this->input->post('curso');
            $instituicao = $this->input->post('instituicao');
            $data_inicio = $this->input->post('data_inicio_formacao');
            $data_fim = $this->input->post('data_fim_formacao');
            $obs = $this->input->post('outras_obs');

            if (!empty($formacao_id))
            {
                foreach ($formacao_id as $key => $id)
                {
                    $data = array(
                        'escolaridade' => $escolaridade[$key],
                        'curso' => $curso[$key],
                        'instituicao' => $instituicao[$key],
                        'data_inicio' => date('Y-m-d', strtotime($data_inicio[$key])),
                    );

                    if (!empty($data_fim[$key]))
                    {
                        $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                    }

                    if (!empty($obs[$key]))
                    {
                        $data['observacoes'] = $obs[$key];
                    }

                    $this->db->where('id', $id);
                    $this->db->update('rh_formacao', $data);
                }  
            }

            // Conta o numero de id que o formacao tem. Para cada escolaridade acima do numero de id's ele adiciona no banco.
            foreach ($escolaridade as $key => $value)
            {
                if (empty($formacao_id[$key]))
                {
                    $data = array(
                        'curriculo_id' => $curriculo_id,
                        'escolaridade' => $value,
                        'curso' => $curso[$key],
                        'instituicao' => $instituicao[$key],
                        'data_inicio' => date('Y-m-d', strtotime($data_inicio[$key])),
                        'created' => date("Y-m-d H:i:s")
                    );

                    if (!empty($data_fim[$key]))
                    {
                        $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                    }

                    if (!empty($obs))
                    {
                        $data['observacoes'] = $obs[$key];
                    }

                    $this->db->insert('rh_formacao', $data);
                }
            }
        }

        private function edit_idioma($curriculo_id)
        {
            $idioma_id = $this->input->post('idioma_id');
            $nome = $this->input->post('idioma');
            $nivel = $this->input->post('nivel_idioma');

            if (!empty($idioma_id))
            {
                foreach ($idioma_id as $key => $id)
                {
                    $data = array(
                        'nome' => $nome[$key],
                        'nivel' => $nivel[$key]
                    );

                    $this->db->where('id', $id);
                    $this->db->update('rh_idioma', $data);
                }
            }

            foreach ($nome as $key => $value)
            {
                if (empty($idioma_id[$key]))
                {
                    $data = array(
                        'curriculo_id' => $curriculo_id,
                        'nome' => $value,
                        'nivel' => $nivel[$key],
                        'created' => date("Y-m-d H:i:s")
                    );

                    $this->db->insert('rh_idioma', $data);
                }
            }
        }

        private function edit_profissional($curriculo_id)
        {
            $profissional_id = $this->input->post('profissional_id');
            $cargo = $this->input->post('cargo');
            $empresa = $this->input->post('empresa');
            $data_inicio = $this->input->post('data_inicio_emp');
            $data_fim = $this->input->post('data_fim_emp');
            $atribuicoes = $this->input->post('atribuicoes');
            $motivo_saida = $this->input->post('motivo_saida');

            if (!empty($profissional_id))
            {
                foreach ($profissional_id as $key => $id)
                {
                    $data = array(
                        'cargo' => $cargo[$key],
                        'empresa' => $empresa[$key],
                        'atribuicoes' => $atribuicoes[$key],
                        'motivo_saida' => $motivo_saida[$key]
                    );

                    if (!empty($data_inicio[$key]))
                    {
                        $data['data_inicio'] = date('Y-m-d', strtotime($data_inicio[$key]));
                    }

                    if (!empty($data_fim[$key]))
                    {
                        $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                    }

                    $this->db->where('id', $id);
                    $this->db->update('rh_profissional', $data);
                }  
            }

            // Conta o numero de id que o profisisonal tem. Para cada cargo acima do numero de id's ele adiciona no banco.
            foreach ($cargo as $key => $value)
            {
                if ($key > $count)
                {
                    $data = array(
                        'curriculo_id' => $curriculo_id,
                        'cargo' => $value,
                        'empresa' => $empresa[$key],
                        'created' => date("Y-m-d H:i:s")
                    );

                    if (!empty($data_inicio[$key]))
                    {
                        $data['data_inicio'] = date('Y-m-d', strtotime($data_inicio[$key]));
                    }

                    if (!empty($data_fim[$key]))
                    {
                        $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                    }

                    if (!empty($atribuicoes))
                    {
                        $data['atribuicoes'] = $atribuicoes[$key];
                    }

                    if (!empty($motivo_saida))
                    {
                        $data['motivo_saida'] = $motivo_saida[$key];
                    }

                    $this->db->insert('rh_profissional', $data);
                }
            }
        }

        public function del($id)
        {
            // Remove a foto
            $this->db->select('foto, foto_thumb');

            $foto_path = $this->db->get_where('rh_curriculo', array('id' => $id))->row();

            if (!empty($foto_path->foto))
            {
                unlink($foto_path->foto);

                unlink($foto_path->foto_thumb);
            }

            $this->db->where('id', $id);
            $this->db->delete('rh_curriculo');

            return TRUE;
        }

    }


/* End of file admin_model.php */
/* Location: ./application/models/admin_model.php */