<?php
    class Auth_model extends CI_Model {

        public function __construct()
        {
            parent::__construct();

            // PHPASS para encriptografar a senha
            require_once(dirname(__FILE__) . '/../libraries/phpass-0.3/PasswordHash.php');

            $this->phpass = new PasswordHash(8, false);
        }

        public function login($email, $password)
        {
            // Checa se o usuario existe
            $this->db->select('id, email, password');

            $query = $this->db->get_where('rh_curriculo', array('email' => $email));

            if ($query->num_rows() == 0)
            {
                return FALSE;
            }

            $data = $query->row_array();

            // Confere a senha. Confere tambem a senha dos usuarios do rh antigo encriptado com md5.
            if (($this->phpass->CheckPassword($password, $data['password'])) AND (md5($password) != $data['password']) == FALSE)
            {
                return FALSE;
            }

            // Destroi a sessao antiga
            $this->session->sess_destroy();

            // Cria uma nova sessao
            $this->session->sess_create();

            // Dados da sessao
            unset($data['password']);
            $data['logged_in'] = TRUE;

            $this->session->set_userdata($data);

            return TRUE;
        }

        public function facebook_login($facebook_id)
        {
            $this->db->select('id, email, facebook_id');

            $query = $this->db->get_where('rh_curriculo', array('facebook_id' => $facebook_id));

            if ($query->num_rows() == 0)
            {
                return FALSE;
            }

            $data = $query->row_array();

            $this->session->sess_destroy();

            $this->session->sess_create();

            $data['logged_in'] = TRUE;

            $this->session->set_userdata($data);

            return TRUE;
        }

        public function is_admin()
        {
            $email = $this->session->userdata('email');

            $this->db->select('group');

            $query = $this->db->get_where('rh_curriculo', array('email' => $email))->row_array();

            if ($query['group'] === 'admin')
            {
                return TRUE;
            }

            return FALSE;
        }

        public function reset_password($email)
        {
            $this->db->select('id');

            $this->db->where('email', $email);

            $query = $this->db->get('rh_curriculo');

            if ($query->num_rows() == 0)
            {
                return array('result' => FALSE);
            }

            $query = $query->row();

            $chars = 

            $new_pass = substr(str_shuffle(strtolower(sha1(rand() . "puracomunicacao"))),0, 6);

            $data = array(
                'password' => $this->phpass->HashPassword($new_pass),
                'modified' => date('c')
            );

            $this->db->where('id', $query->id);
            $this->db->update('rh_curriculo', $data);

            $result = array(
                'pass' => $new_pass,
                'result' => TRUE
            );

            return $result;
        }

    }


/* End of file auth_model.php */
/* Location: ./application/models/auth_model.php */