<?php
    class Curriculo_model extends CI_Model {

        public function __construct()
        {
            parent::__construct();

            // PHPASS para encriptografar a senha
            require_once(dirname(__FILE__) . '/../libraries/phpass-0.3/PasswordHash.php');

            $this->phpass = new PasswordHash(8, false);
        }

        public function add_curriculo()
        {
            // Encripta a senha
            $password = $this->input->post('senha');
            $hashed_password = $this->phpass->HashPassword($password);

            // Organiza os dados
            $data = array(
                'email' => $this->input->post('email'),
                'password' => $hashed_password,
                'group' => 'user',
                'facebook_id' => $this->input->post('facebook_id'),
                'nome' => $this->input->post('nome'),
                'cpf' => $this->input->post('cpf'),
                'data_nasc' => date('Y-m-d', strtotime($this->input->post('data_nasc'))),
                'sexo' => $this->input->post('sexo'),
                'est_civil' => $this->input->post('est_civil'),
                'portf_digital' => $this->input->post('portf_digital'),
                'telefone' => $this->input->post('telefone'),
                'celular' => $this->input->post('celular'),
                'endereco' => $this->input->post('endereco'),
                'bairro' => $this->input->post('bairro'),
                'cidade' => $this->input->post('cidade'),
                'estado' => $this->input->post('estado'),
                'complemento' => $this->input->post('compl'),
                'cep' => $this->input->post('cep'),
                'pais' => $this->input->post('pais'),
                'area_desejada' => $this->input->post('area_desejada'),
                'area_desejada2' => $this->input->post('area_desejada2'),
                'area_desejada3' => $this->input->post('area_desejada3'),
                'hierarquia' => $this->input->post('hierarquia'),
                'hierarquia2' => $this->input->post('hierarquia2'),
                'obj_pessoal' => $this->input->post('obj_pessoal'),
                'pret_salarial' => $this->input->post('pret_salarial'),
                'created' => date("Y-m-d H:i:s")
            );

            // Adiciona a foto
            if ($_FILES['foto']['error'] == 0)
            {
                // faz o upload da foto
                $config['upload_path'] = './public/foto';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['remove_spaces'] = TRUE;
                $this->load->library('upload', $config);

                $this->upload->do_upload('foto');

                $data_foto = $this->upload->data();
                $foto = 'public/foto/' . $data_foto['file_name'];

                // cria thumbnail
                $config['image_library'] = 'gd2';
                $config['source_image'] = $data_foto['full_path'];
                $config['create_thumb'] = TRUE;
                $config['maintain_ratio'] = TRUE;
                $config['width']     = 40;
                $config['height']   = 50;

                $this->load->library('image_lib', $config); 

                $this->image_lib->resize();

                $foto_thumb = 'public/foto/' . $data_foto['raw_name'] . '_thumb' . $data_foto['file_ext'];

                // adiciona ao array de dados
                $data['foto'] = $foto;
                $data['foto_thumb'] = $foto_thumb;
            }

            $this->db->insert('rh_curriculo', $data);

            // Id do curriculo adicionado
            $curriculo_id = $this->db->insert_id();

            // Formacao
            $this->add_formacao($curriculo_id);

            // Idioma
            $idioma = $this->input->post('idioma');

            if (!empty($idioma[0]))
            {
                $this->add_idioma($curriculo_id);
            }

            // Profissional
            // verifica se o usuario marcou a opcao 'sem experiencia profissional'
            $sem_exp = $this->input->post('sem_exp');

            if (!$sem_exp)
            {
                $this->add_profissional($curriculo_id);
            }

            return TRUE;
        }

        private function add_formacao($curriculo_id)
        {
            $escolaridade = $this->input->post('escolaridade');
            $curso = $this->input->post('curso');
            $instituicao = $this->input->post('instituicao');
            $data_inicio = $this->input->post('data_inicio_formacao');
            $data_fim = $this->input->post('data_fim_formacao');
            $observacoes = $this->input->post('outras_obs_formacao');

            foreach ($escolaridade as $key => $value)
            {
                $data = array(
                    'curriculo_id' => $curriculo_id,
                    'escolaridade' => $value,
                    'curso' => $curso[$key],
                    'instituicao' => $instituicao[$key],
                    'data_inicio' => date('Y-m-d', strtotime($data_inicio[$key])),
                    'created' => date("Y-m-d H:i:s")
                );

                if (!empty($data_fim[$key]))
                {
                    $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                }

                if (!empty($observacoes[$key]))
                {
                    $data['observacoes'] = $observacoes[$key];
                }

                $this->db->insert('rh_formacao', $data);
            }
        }

        private function add_idioma($curriculo_id)
        {
            $nome = $this->input->post('idioma');
            $nivel = $this->input->post('nivel_idioma');

            foreach ($nome as $key => $value)
            {
                $data = array(
                    'curriculo_id' => $curriculo_id,
                    'nome' => $value,
                    'nivel' => $nivel[$key],
                    'created' => date("Y-m-d H:i:s")
                );

                $this->db->insert('rh_idioma', $data);
            }
        }

        private function add_profissional($curriculo_id)
        {
            $cargo = $this->input->post('cargo');
            $empresa = $this->input->post('empresa');
            $data_inicio = $this->input->post('data_inicio_emp');
            $data_fim = $this->input->post('data_fim_emp');
            $atribuicoes = $this->input->post('atribuicoes');
            $motivo_saida = $this->input->post('motivo_saida');

            foreach ($cargo as $key => $value)
            {
                $data = array(
                    'curriculo_id' => $curriculo_id,
                    'cargo' => $value,
                    'empresa' => $empresa[$key],
                    'created' => date("Y-m-d H:i:s")
                );

                if (!empty($data_inicio[$key]))
                {
                    $data['data_inicio'] = date('Y-m-d', strtotime($data_inicio[$key]));
                }

                if (!empty($data_fim[$key]))
                {
                    $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                }

                if (!empty($atribuicoes[$key]))
                {
                    $data['atribuicoes'] = $atribuicoes[$key];
                }

                if (!empty($motivo_saida[$key]))
                {
                    $data['motivo_saida'] = $motivo_saida[$key];
                }

                $this->db->insert('rh_profissional', $data);
            }
        }

        public function fetch_curriculo($id)
        {
            // Curriculo
            $this->db->select('email, nome, cpf, data_nasc, sexo, est_civil, portf_digital, foto, telefone, celular, endereco, bairro, cidade, estado, complemento, cep, pais, area_desejada, area_desejada2, area_desejada3, hierarquia, hierarquia2, obj_pessoal, pret_salarial');

            $data['curriculo'] = $this->db->get_where('rh_curriculo', array('id' => $id))->row();

            // Formacao
            $this->db->select('id, escolaridade, curso, instituicao, data_inicio, data_fim, observacoes');

            $data['formacoes'] = $this->db->get_where('rh_formacao', array('curriculo_id' => $id))->result();

            // Idioma
            $this->db->select('id, nome, nivel');

            $data['idiomas'] = $this->db->get_where('rh_idioma', array('curriculo_id' => $id))->result();

            // Profissional
            $this->db->select('id, cargo, empresa, data_inicio, data_fim, atribuicoes, motivo_saida');

            $data['profissionais'] = $this->db->get_where('rh_profissional', array('curriculo_id' => $id))->result();

            return $data;
        }

        public function update_curriculo($id)
        {
            // Organiza os dados
            $data = array(
                'email' => $this->input->post('email'),
                'facebook_id' => $this->input->post('facebook_id'),
                'nome' => $this->input->post('nome'),
                'cpf' => $this->input->post('cpf'),
                'data_nasc' => date('Y-m-d', strtotime($this->input->post('data_nasc'))),
                'sexo' => $this->input->post('sexo'),
                'est_civil' => $this->input->post('est_civil'),
                'portf_digital' => $this->input->post('portf_digital'),
                'telefone' => $this->input->post('telefone'),
                'celular' => $this->input->post('celular'),
                'endereco' => $this->input->post('endereco'),
                'bairro' => $this->input->post('bairro'),
                'cidade' => $this->input->post('cidade'),
                'estado' => $this->input->post('estado'),
                'complemento' => $this->input->post('compl'),
                'cep' => $this->input->post('cep'),
                'pais' => $this->input->post('pais'),
                'area_desejada' => $this->input->post('area_desejada'),
                'area_desejada2' => $this->input->post('area_desejada2'),
                'area_desejada3' => $this->input->post('area_desejada3'),
                'hierarquia' => $this->input->post('hierarquia'),
                'hierarquia2' => $this->input->post('hierarquia2'),
                'obj_pessoal' => $this->input->post('obj_pessoal'),
                'pret_salarial' => $this->input->post('pret_salarial'),
                'modified' => date("Y-m-d H:i:s")
            );

            $password = $this->input->post('senha');

            // Verifica se a senha foi alterado, se tiver sido ele altera a senha
            if (!empty($password))
            {
                $data['password'] = $this->phpass->HashPassword($password);
            }

            $this->db->where('id', $id);
            $this->db->update('rh_curriculo', $data);

            // Formacao
            $this->update_formacao($id);

            // Idioma
            $idioma = $this->input->post('idioma');

            if (!empty($idioma[0]))
            {
                $this->update_idioma($id);
            }

            // Profissional
            // verifica se o usuario nao adicionou alguma experiencia
            $cargo = $this->input->post('cargo');

            if (!empty($cargo[0]))
            {
                $this->update_profissional($id);
            }

            return TRUE;
        }

        private function update_formacao($curriculo_id)
        {
            $formacao_id = $this->input->post('formacao_id');
            $escolaridade = $this->input->post('escolaridade');
            $curso = $this->input->post('curso');
            $instituicao = $this->input->post('instituicao');
            $data_inicio = $this->input->post('data_inicio_formacao');
            $data_fim = $this->input->post('data_fim_formacao');
            $obs = $this->input->post('outras_obs');

            if (!empty($formacao_id))
            {
                foreach ($formacao_id as $key => $id)
                {
                    $data = array(
                        'escolaridade' => $escolaridade[$key],
                        'curso' => $curso[$key],
                        'instituicao' => $instituicao[$key],
                        'data_inicio' => date('Y-m-d', strtotime($data_inicio[$key])),
                    );

                    if (!empty($data_fim[$key]))
                    {
                        $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                    }

                    if (!empty($obs[$key]))
                    {
                        $data['observacoes'] = $obs[$key];
                    }

                    $this->db->where('id', $id);
                    $this->db->update('rh_formacao', $data);
                }  
            }

            // Conta o numero de id que o formacao tem. Para cada escolaridade acima do numero de id's ele adiciona no banco.
            foreach ($escolaridade as $key => $value)
            {
                if (empty($formacao_id[$key]))
                {
                    $data = array(
                        'curriculo_id' => $curriculo_id,
                        'escolaridade' => $value,
                        'curso' => $curso[$key],
                        'instituicao' => $instituicao[$key],
                        'data_inicio' => date('Y-m-d', strtotime($data_inicio[$key])),
                        'created' => date("Y-m-d H:i:s")
                    );

                    if (!empty($data_fim[$key]))
                    {
                        $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                    }

                    if (!empty($obs))
                    {
                        $data['observacoes'] = $obs[$key];
                    }

                    $this->db->insert('rh_formacao', $data);
                }
            }
        }

        private function update_idioma($curriculo_id)
        {
            $idioma_id = $this->input->post('idioma_id');
            $nome = $this->input->post('idioma');
            $nivel = $this->input->post('nivel_idioma');

            if (!empty($idioma_id))
            {
                foreach ($idioma_id as $key => $id)
                {
                    $data = array(
                        'nome' => $nome[$key],
                        'nivel' => $nivel[$key]
                    );

                    $this->db->where('id', $id);
                    $this->db->update('rh_idioma', $data);
                }
            }

            foreach ($nome as $key => $value)
            {
                if (empty($idioma_id[$key]))
                {
                    $data = array(
                        'curriculo_id' => $curriculo_id,
                        'nome' => $value,
                        'nivel' => $nivel[$key],
                        'created' => date("Y-m-d H:i:s")
                    );

                    $this->db->insert('rh_idioma', $data);
                }
            }
        }

        private function update_profissional($curriculo_id)
        {
            $profissional_id = $this->input->post('profissional_id');
            $cargo = $this->input->post('cargo');
            $empresa = $this->input->post('empresa');
            $data_inicio = $this->input->post('data_inicio_emp');
            $data_fim = $this->input->post('data_fim_emp');
            $atribuicoes = $this->input->post('atribuicoes');
            $motivo_saida = $this->input->post('motivo_saida');

            if (!empty($profissional_id))
            {
                foreach ($profissional_id as $key => $id)
                {
                    $data = array(
                        'cargo' => $cargo[$key],
                        'empresa' => $empresa[$key],
                        'atribuicoes' => $atribuicoes[$key],
                        'motivo_saida' => $motivo_saida[$key]
                    );

                    if (!empty($data_inicio[$key]))
                    {
                        $data['data_inicio'] = date('Y-m-d', strtotime($data_inicio[$key]));
                    }

                    if (!empty($data_fim[$key]))
                    {
                        $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                    }

                    $this->db->where('id', $id);
                    $this->db->update('rh_profissional', $data);
                }  
            }

            // Conta o numero de id que o profisisonal tem. Para cada cargo acima do numero de id's ele adiciona no banco.
            foreach ($cargo as $key => $value)
            {
                if (empty($profissional_id[$key]))
                {
                    $data = array(
                        'curriculo_id' => $curriculo_id,
                        'cargo' => $value,
                        'empresa' => $empresa[$key],
                        'created' => date("Y-m-d H:i:s")
                    );

                    if (!empty($data_inicio[$key]))
                    {
                        $data['data_inicio'] = date('Y-m-d', strtotime($data_inicio[$key]));
                    }

                    if (!empty($data_fim[$key]))
                    {
                        $data['data_fim'] = date('Y-m-d', strtotime($data_fim[$key]));
                    }

                    if (!empty($atribuicoes))
                    {
                        $data['atribuicoes'] = $atribuicoes[$key];
                    }

                    if (!empty($motivo_saida))
                    {
                        $data['motivo_saida'] = $motivo_saida[$key];
                    }

                    $this->db->insert('rh_profissional', $data);
                }
            }
        }

    }


/* End of file curriculo_model.php */
/* Location: ./application/models/curriculo_model.php */